import 'dart:ui';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:nb_utils/nb_utils.dart';
import 'package:streamit_laravel/components/cached_image_widget.dart';
import 'package:streamit_laravel/main.dart';
import 'package:streamit_laravel/network/core_api.dart';
import 'package:streamit_laravel/utils/app_common.dart';
import 'package:streamit_laravel/utils/colors.dart';
import 'package:streamit_laravel/utils/common_base.dart';
import 'package:streamit_laravel/generated/assets.dart';
import 'package:streamit_laravel/utils/constants.dart';
import '../model/profile_watching_model.dart';
import '../watching_profile_controller.dart';

class ProfileComponent extends StatelessWidget {
  final WatchingProfileModel profile;
  final WatchingProfileController profileWatchingController;
  final double height;
  final double width;
  final EdgeInsets padding;
  final double imageSize;
  final bool isChildProfile;

  const ProfileComponent({
    super.key,
    required this.profile,
    required this.profileWatchingController,
    required this.height,
    required this.width,
    required this.padding,
    required this.imageSize,
    required this.isChildProfile,
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        if (profile.isChildProfile == 0 && getStringAsync(SharedPreferenceConst.PIN) != "" && selectedAccountProfile.value.isChildProfile == 1) {
          Get.bottomSheet(
            isDismissible: true,
            isScrollControlled: true,
            enableDrag: false,
            BackdropFilter(
              filter: ImageFilter.blur(sigmaX: 3, sigmaY: 3),
              child: Container(
                width: double.infinity,
                padding: EdgeInsets.symmetric(vertical: 16),
                decoration: boxDecorationDefault(
                  borderRadius: const BorderRadius.only(
                    topLeft: Radius.circular(32),
                    topRight: Radius.circular(32),
                  ),
                  border: Border(top: BorderSide(color: borderColor.withValues(alpha: 0.8))),
                  color: appScreenBackgroundDark,
                ),
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      20.height,
                      Text(
                        locale.value.parentalLock,
                        style: commonW500PrimaryTextStyle(size: 20),
                      ),
                      8.height,
                      Text(
                        locale.value.enter4DigitParentalControlPIN,
                        style: secondaryTextStyle(),
                      ),
                      20.height,
                      SizedBox(
                        height: 42,
                        child: OTPTextField(
                          pinLength: 4,
                          fieldWidth: 42,
                          cursorColor: appColorPrimary,
                          textStyle: primaryTextStyle(),
                          decoration: InputDecoration(
                            counter: const Offstage(),
                            contentPadding: const EdgeInsets.only(bottom: 8, left: 2),
                            fillColor: cardDarkColor,
                            focusColor: primaryTextColor,
                            focusedBorder: OutlineInputBorder(
                              borderSide: const BorderSide(color: borderColor, width: 0.0),
                              borderRadius: BorderRadius.circular(4.0),
                            ),
                            enabledBorder: OutlineInputBorder(
                              borderSide: const BorderSide(color: transparentColor, width: 0.0),
                              borderRadius: BorderRadius.circular(4.0),
                            ),
                            errorBorder: OutlineInputBorder(
                              borderSide: const BorderSide(color: transparentColor, width: 0.0),
                              borderRadius: BorderRadius.circular(4.0),
                            ),
                          ),
                          boxDecoration: BoxDecoration(
                            color: cardDarkColor,
                            borderRadius: BorderRadius.circular(4.0),
                          ),
                          onChanged: (String code) {
                            profileWatchingController.updatePin(code);
                          },
                          onCompleted: (String verificationCode) {
                            hideKeyboard(context);
                            profileWatchingController.pin.value = verificationCode;
                            CoreServiceApis.verifyPin(loginUserData.value.id, profileWatchingController.pin.value).then((value) {
                              toast(value.message);
                              if (value.status == true) {
                                profileWatchingController.handleSelectProfile(profile);
                              }
                            }).catchError((value) {
                              toast(value);
                            });
                          },
                        ),
                      ),
                      20.height,
                      AppButton(
                        text: locale.value.submit,
                        color: appColorPrimary,
                        textStyle: appButtonTextStyleWhite,
                        shapeBorder: RoundedRectangleBorder(
                          borderRadius: radius(defaultAppButtonRadius / 2),
                        ),
                        onTap: () {
                          hideKeyboard(context);
                          CoreServiceApis.verifyPin(loginUserData.value.id, profileWatchingController.pin.value).then((value) {
                            toast(value.message);
                            if (value.status == true) {
                              profileWatchingController.handleSelectProfile(profile);
                            }
                          }).catchError((value) {
                            toast(value);
                          });
                        },
                      ),
                      20.height,
                    ],
                  ),
                ),
              ),
            ),
          ).then((value) {
            if (value == true) {
              profileWatchingController.handleSelectProfile(profile);
            }
          });
        } else {
          profileWatchingController.handleSelectProfile(profile);
        }
      },
      child: Container(
        height: height,
        width: width,
        padding: padding,
        alignment: Alignment.center,
        decoration: boxDecorationDefault(
          borderRadius: radius(4),
          color: cardColor,
          border: Border.all(color: profile.id == profileId.value ? appColorPrimary.withValues(alpha: 0.6) : borderColor),
        ),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            SizedBox(
              width: imageSize,
              height: imageSize,
              child: ClipOval(
                child: Stack(
                  alignment: Alignment.bottomCenter,
                  children: [
                    // Circular Profile Image
                    CachedImageWidget(
                      url: profile.avatar,
                      width: imageSize,
                      height: imageSize,
                      fit: BoxFit.cover,
                    ),

                    // Transparent Overlay (Top 70%)
                    if (isChildProfile)
                      Positioned(
                        top: 0,
                        child: Container(
                          width: imageSize,
                          height: imageSize * 0.72,
                          color: Colors.white.withValues(alpha: 0.2),
                        ),
                      ),

                    // KIDS Label (Bottom 30%)
                    if (profile.isChildProfile == 1)
                      Positioned(
                        bottom: 0,
                        child: Container(
                          width: imageSize,
                          height: imageSize * 0.27,
                          color: Colors.red,
                          alignment: Alignment.center,
                          child: Text(
                            locale.value.kids,
                            style: TextStyle(
                              color: Colors.white,
                              fontSize: 12,
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ),
                      ),
                  ],
                ),
              ),
            ),

            10.height,
            // Profile name
            Marquee(
              child: Text(
                profile.name.capitalizeEachWord(),
                textAlign: TextAlign.center,
                style: primaryTextStyle(size: 14),
              ),
            ),
            4.height,
            // Edit button
            TextIcon(
              onTap: () {
                if (getStringAsync(SharedPreferenceConst.PIN) != "" && selectedAccountProfile.value.isChildProfile == 1) {
                  Get.bottomSheet(BackdropFilter(
                    filter: ImageFilter.blur(sigmaX: 3, sigmaY: 3),
                    child: Container(
                      width: double.infinity,
                      padding: EdgeInsets.symmetric(vertical: 16),
                      decoration: boxDecorationDefault(
                        borderRadius: const BorderRadius.only(
                          topLeft: Radius.circular(32),
                          topRight: Radius.circular(32),
                        ),
                        border: Border(top: BorderSide(color: borderColor.withValues(alpha: 0.8))),
                        color: appScreenBackgroundDark,
                      ),
                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            20.height,
                            Text(
                              locale.value.parentalLock,
                              style: commonW500PrimaryTextStyle(size: 20),
                            ),
                            8.height,
                            Text(
                              locale.value.enter4DigitParentalControlPIN,
                              style: secondaryTextStyle(),
                            ),
                            20.height,
                            SizedBox(
                              height: 42,
                              child: OTPTextField(
                                pinLength: 4,
                                fieldWidth: 42,
                                cursorColor: appColorPrimary,
                                textStyle: primaryTextStyle(),
                                decoration: InputDecoration(
                                  counter: const Offstage(),
                                  contentPadding: const EdgeInsets.only(bottom: 8, left: 2),
                                  fillColor: cardDarkColor,
                                  focusColor: primaryTextColor,
                                  focusedBorder: OutlineInputBorder(
                                    borderSide: const BorderSide(color: borderColor, width: 0.0),
                                    borderRadius: BorderRadius.circular(4.0),
                                  ),
                                  enabledBorder: OutlineInputBorder(
                                    borderSide: const BorderSide(color: transparentColor, width: 0.0),
                                    borderRadius: BorderRadius.circular(4.0),
                                  ),
                                  errorBorder: OutlineInputBorder(
                                    borderSide: const BorderSide(color: transparentColor, width: 0.0),
                                    borderRadius: BorderRadius.circular(4.0),
                                  ),
                                ),
                                boxDecoration: BoxDecoration(
                                  color: cardDarkColor,
                                  borderRadius: BorderRadius.circular(4.0),
                                ),
                                onChanged: (String code) {
                                  profileWatchingController.updatePin(code);
                                },
                                onCompleted: (String verificationCode) {
                                  hideKeyboard(context);
                                  profileWatchingController.pin.value = verificationCode;
                                  CoreServiceApis.verifyPin(loginUserData.value.id, profileWatchingController.pin.value).then((value) {
                                    toast(value.message);
                                    if (value.status == true) {
                                      profileWatchingController.handleAddEditProfile(profile, true);
                                    }
                                  }).catchError((value) {
                                    toast(value);
                                  });
                                },
                              ),
                            ),
                            20.height,
                            AppButton(
                              text: locale.value.submit,
                              color: appColorPrimary,
                              textStyle: appButtonTextStyleWhite,
                              shapeBorder: RoundedRectangleBorder(
                                borderRadius: radius(defaultAppButtonRadius / 2),
                              ),
                              onTap: () {
                                hideKeyboard(context);
                                CoreServiceApis.verifyPin(loginUserData.value.id, profileWatchingController.pin.value).then((value) {
                                  toast(value.message);
                                  if (value.status == true) {
                                    profileWatchingController.handleSelectProfile(profile);
                                  }
                                }).catchError((value) {
                                  toast(value);
                                });
                              },
                            ),
                            20.height,
                          ],
                        ),
                      ),
                    ),
                  ));
                } else {
                  profileWatchingController.handleAddEditProfile(profile, true);
                }
              },
              prefix: Image.asset(
                Assets.iconsIcEdit,
                width: 14,
                height: 14,
                color: iconColor,
              ),
              text: locale.value.edit,
              maxLine: 1,
              spacing: 4,
              textStyle: commonW500SecondaryTextStyle(size: 12, color: iconColor),
              useMarquee: true,
            )
          ],
        ),
      ),
    );
  }
}
