import 'dart:developer';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:streamit_laravel/main.dart';
import 'package:streamit_laravel/network/core_api.dart';
import 'package:streamit_laravel/screens/home/home_controller.dart';
import 'package:streamit_laravel/screens/home/model/dashboard_res_model.dart';
import 'package:streamit_laravel/screens/movie_list/movie_list_controller.dart';
import 'package:streamit_laravel/screens/profile/profile_controller.dart';
import 'package:streamit_laravel/screens/tv_show/tvshow_list_controller.dart';
import 'package:streamit_laravel/screens/video/video_list_controller.dart';
import 'package:streamit_laravel/screens/watch_list/watch_list_controller.dart';
import 'package:streamit_laravel/utils/api_end_points.dart';
import 'package:streamit_laravel/utils/common_base.dart';
import 'package:streamit_laravel/video_players/model/video_model.dart';

import '../../../utils/app_common.dart';

class SliderController extends GetxController {
  final String type;

  SliderController({required this.type});

  RxBool isLoading = true.obs;
  RxBool isWatchListLoading = false.obs;
  Rx<PageController> sliderPageController = PageController(initialPage: 0).obs;
  Rx<Future<RxList<SliderModel>>> getBannerList = Future(() => RxList<SliderModel>()).obs;
  RxList<SliderModel> bannerList = RxList();
  HomeController controller = Get.put(HomeController());
  final MovieListController movieListController = MovieListController();
  final TvShowListController tvShowListController = TvShowListController();
  final VideoListController videoListController = VideoListController();
  RxString languageName = "".obs;
  @override
  void onInit() {
    //  Get.put(GlobalVideoController());
    if (Get.arguments is String) {
      languageName(Get.arguments);
    }
    getBanner(showLoader: true);
    super.onInit();
  }

  @override
  void onClose() {
    sliderPageController.value.dispose();
    movieListController.page.value = 1;
    tvShowListController.page.value = 1;
      videoListController.page.value = 1;
    super.onClose();
  }

  Future<void> getBanner({bool showLoader = true}) async {
    isLoading(true);
    await CoreServiceApis.getSliderDetail(getBannerList: bannerList, type: type).then((value) async {
      isLoading(false);
      bannerList(value);
      if (type == "movie") {
        await movieListController.getMovieDetails(showLoader: true,language:  languageName.value);
      } else if (type == 'tvshow') {
        await tvShowListController.getTvShowDetails(showLoader: true);
      } else if (type == 'video') {
        videoListController.getVideoList(showLoader: true);
      }
      isLoading(false);
    }).catchError((e) {
      isLoading(false);
      log("getBanner List Err : $e");
    }).whenComplete(() => isLoading(false));
    isLoading(false); // only after movie data is fetched
  }

  Future<void> onNextPage() async {
    if (type == "movie") {
      if (!movieListController.isLastPage.value) {
        movieListController.page++;
        await movieListController.getMovieDetails(viewShimmer: false);
      }
    } else if (type == "tvshow") {
      if (!tvShowListController.isLastPage.value) {
        tvShowListController.page++;
        await tvShowListController.getTvShowDetails(viewShimmer: false);
      }
    } else if (type == "video") {
      if (!videoListController.isLastPage.value) {
        videoListController.page++;
        await videoListController.getVideoList(showShimmers: false);
      }
    } else {
      log("Unknown type: $type");
    }
  }



  saveWatchLists(index, {bool addToWatchList = true}) {
    if (isWatchListLoading.isTrue) return;
    isWatchListLoading(true);

    if (addToWatchList) {
      CoreServiceApis.saveWatchList(
        request: {
          "entertainment_id": bannerList[index].id,
          if (profileId.value != 0) "profile_id": profileId.value,
        },
      ).then((value) async {
        await getBanner();
        successSnackBar(locale.value.addedToWatchList);
        updateWatchList();
      }).catchError((e) {
        errorSnackBar(error: e);
      }).whenComplete(() {
        isWatchListLoading(false);
      });
    } else {
      CoreServiceApis.deleteFromWatchlist(idList: [bannerList[index].data.id]).then((value) async {
        await getBanner();
        successSnackBar(locale.value.removedFromWatchList);
        updateWatchList();
      }).catchError((e) {
        errorSnackBar(error: e);
      }).whenComplete(() {
        isWatchListLoading(false);
      });
    }
  }

  updateWatchList() {
    Get.isRegistered<ProfileController>() ? Get.find<ProfileController>() : Get.put(ProfileController());

    WatchListController controller = Get.isRegistered<WatchListController>() ? Get.find<WatchListController>() : Get.put(WatchListController());
    controller.getWatchList(showLoader: false);
  }
}
