// ignore_for_file: must_be_immutable

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:nb_utils/nb_utils.dart';
import 'package:streamit_laravel/components/custom_icon_button_widget.dart';
import 'package:streamit_laravel/screens/video/video_details_controller.dart';
import 'package:streamit_laravel/generated/assets.dart';

import '../../../../utils/app_common.dart';
import '../../../../utils/colors.dart';
import '../../../../utils/common_base.dart';
import '../../../../utils/constants.dart';
import '../../../auth/sign_in/sign_in_screen.dart';
import '../../../movie_details/components/more_list/more_list_component.dart';
import '../model/video_details_resp.dart';

class VideoDetailsComponent extends StatelessWidget {
  final VideoDetailsModel videoDetail;
  final VideoDetailsController movieDetailCont;

  const VideoDetailsComponent({
    super.key,
    required this.videoDetail,
    required this.movieDetailCont,
  });

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      mainAxisAlignment: MainAxisAlignment.start,
      children: [
        Wrap(
          spacing: 12,
          runSpacing: 12,
          children: [
            CustomIconButton(
              icon: Assets.iconsIcPlus,
              color: iconColor,
              onTap: () {
                if (isLoggedIn.isTrue) {
                  movieDetailCont.saveWatchList(addToWatchList: !videoDetail.isWatchList);
                } else {
                  LiveStream().emit(podPlayerPauseKey);
                  Get.to(() => SignInScreen())?.then((value) {
                    if (isLoggedIn.isTrue) {
                      movieDetailCont.saveWatchList(addToWatchList: !videoDetail.isWatchList);
                    }
                  });
                }
              },
              isTrue: videoDetail.isWatchList,
              checkIcon: Assets.iconsIcCheck,
            ),
            CustomIconButton(
                icon: Assets.iconsIcShare,
                onTap: () {
                  shareVideo(type: VideoType.video, videoId: videoDetail.id);
                }),
            if (movieDetailCont.showDownload.value)
              Obx(
                () {
                  if (movieDetailCont.downloadPercentage.value >= 1 && movieDetailCont.downloadPercentage.value < 100) {
                    return Container(
                      height: 42,
                      width: 42,
                      padding: EdgeInsets.all(4),
                      decoration: boxDecorationDefault(
                        color: circleColor,
                        shape: BoxShape.circle,
                      ),
                      alignment: Alignment.center,
                      child: Marquee(
                        child: Text(
                          '${movieDetailCont.downloadPercentage.value}'.suffixText(value: '%'),
                          style: primaryTextStyle(color: appColorPrimary),
                        ),
                      ),
                    );
                  } else {
                    return CustomIconButton(
                      icon: movieDetailCont.isDownloaded.value ? Assets.iconsIcDownloaded : Assets.iconsIcDownload,
                      color: iconColor,
                      onTap: () async {
                        if (movieDetailCont.isDownloaded.value || movieDetailCont.movieDetailsResp.value.requiredPlanLevel == 0) {
                          movieDetailCont.handleDownload(context);
                        } else {
                          onSubscriptionLoginCheck(
                            videoAccess: movieDetailCont.movieDetailsResp.value.access,
                            callBack: () {
                              if (currentSubscription.value.level >= movieDetailCont.movieDetailsResp.value.requiredPlanLevel) {
                                movieDetailCont.handleDownload(context);
                              }
                            },
                            planId: videoDetail.planId,
                            planLevel: videoDetail.requiredPlanLevel,
                          );
                        }
                      },
                    );
                  }
                },
              ),
            CustomIconButton(
              icon: Assets.iconsIcThumbsup,
              onTap: () {
                if (isLoggedIn.isTrue) {
                  movieDetailCont.addLike();
                } else {
                  LiveStream().emit(podPlayerPauseKey);
                  Get.to(() => SignInScreen())?.then((value) {
                    if (isLoggedIn.isTrue) {
                      movieDetailCont.addLike();
                    }
                  });
                }
              },
              isTrue: videoDetail.isLiked,
              checkIcon: Assets.iconsIcLike,
            ),
            CustomIconButton(
              icon: Assets.iconsIcPictureInPicture,
              color: iconColor,
              onTap: () async {
                /// Handle Picture In Picture Mode
                handlePip(controller: movieDetailCont, context: context);
              },
            ),
          ],
        ).paddingSymmetric(horizontal: 10, vertical: 16),
        MoreListComponent(moreList: videoDetail.moreItems).visible(videoDetail.moreItems.isNotEmpty),
      ],
    );
  }
}
